/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.monitor;

import com.ibm.hwmca.base.monitor.MonitorCondition;
import com.ibm.hwmca.base.monitor.MonitorConditionResult;
import com.ibm.hwmca.base.monitor.MonitorUtils;
import com.ibm.hwmca.base.monitor.ObjectWrapper;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Properties;

public class MonitorMemory
implements MonitorCondition {
    private static final String TRACE_MASKD = "XMONMMED";
    private static final String TRACE_MASKF = "XMONMMEF";
    private static final String TRACE_MASKT = "XMONMMET";
    private static final String THRESHOLD_KEY_WORD = "threshold";
    private static final String PROGRAM_KEY_WORD = "program";
    private int threshold = Integer.MAX_VALUE;
    private String program = null;

    public static void main(String[] args) {
    }

    public void init(String arg) throws HException {
        Properties properties = null;
        String value = null;
        Trace.trace(TRACE_MASKT, "-> init(" + arg + ")");
        if (arg != null && arg.length() > 0) {
            properties = MonitorUtils.createProperties(arg);
            value = (String)properties.get(THRESHOLD_KEY_WORD);
            if (value == null) {
                throw new HException("No threshold specified in argument.");
            }
            this.threshold = Integer.parseInt(value);
            this.program = (String)properties.get(PROGRAM_KEY_WORD);
            if (this.program == null) {
                throw new HException("No program specified in argument.");
            }
        }
        Trace.trace(TRACE_MASKT, "<- init(...)");
    }

    public MonitorConditionResult checkCondition(ObjectWrapper token) {
        MonitorConditionResult result = null;
        Object command = null;
        boolean exitRC = false;
        Object stdOut = null;
        Integer numOfMeg = null;
        Trace.trace(TRACE_MASKT, "-> conditionTrue(" + token + ")");
        result = new MonitorConditionResult(false);
        numOfMeg = this.getNumOfMeg();
        if (numOfMeg != null && numOfMeg >= this.threshold) {
            result = new MonitorConditionResult(true);
        }
        Trace.trace(TRACE_MASKT, "<- conditionTrue(...) returning " + result + " and wrapped object of " + token.getObject());
        return result;
    }

    public void terminate() {
        Trace.trace(TRACE_MASKT, "-> terminate()");
        Trace.trace(TRACE_MASKT, "<- terminate()");
    }

    private Integer getNumOfMeg() {
        Integer result = null;
        String[] command = null;
        ObjectWrapper stdOut = null;
        int exitRC = 0;
        String memory = null;
        int kiloBytes = 0;
        Trace.trace(TRACE_MASKT, "-> getNumOfMeg()");
        command = new String[]{"/bin/bash", "-c", "top -bn1 | grep ccfw | grep " + this.program};
        stdOut = new ObjectWrapper();
        exitRC = MonitorUtils.execute(command, stdOut, null);
        if (exitRC == 0 && stdOut.getObject() != null && (memory = MonitorUtils.getWordX((String)stdOut.getObject(), 5)) != null) {
            if (memory.length() > 1 && (memory.charAt(memory.length() - 1) == 'm' || memory.charAt(memory.length() - 1) == 'M')) {
                memory = memory.substring(0, memory.length() - 1);
                try {
                    result = new Integer(memory);
                }
                catch (NumberFormatException e) {}
            } else {
                try {
                    kiloBytes = Integer.parseInt(memory);
                    result = new Integer(kiloBytes / 1024);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- getNumOfMeg() returning " + result);
        return result;
    }
}

